/**
 * Beschrijft een softwareontwikkelaar.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-05-20
 */
public class SoftwareOntwikkelaar extends Werknemer
{
    private boolean isSenior;
    
    /**
     * Constructor voor objecten van de klasse SoftwareOntwikkelaar.
     * @param   naam    De naam van de softwareontwikkelaar.
     */
    public SoftwareOntwikkelaar(String naam)
    {
        super(naam);
        isSenior = false;
    }

    /**
     * Berekent het maandloon van de softwareontwikkelaar.
     * @return  Het maandloon van de softwareontwikkelaar.
     */
    public double berekenMaandloon()
    {
        if(isSenior) 
        {
            return super.berekenMaandloon() * 1.1;
        }
        else
        {
            return super.berekenMaandloon();
        }
    }
    
    /**
     * Toont informatie over de softwareontwikkelaar in het terminalvenster.
     */
    public void printInfo()
    {
        super.printInfo();
        System.out.println("Ancienniteit: " + ancienniteit);
    }
    
}
